# ICD 11 - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ICD 11**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-condition-definitions.md) 
*  [Mappings](StructureDefinition-bd-condition-mappings.md) 
*  [XML](StructureDefinition-bd-condition.profile.xml.md) 
*  [JSON](StructureDefinition-bd-condition.profile.json.md) 
*  [TTL](StructureDefinition-bd-condition.profile.ttl.md) 

## Resource Profile: ICD 11 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-condition | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDConditionProfile |

 
Condition coded with ICD-11 

**Usages:**

* Refer to this Profile: [Encounter Profile for Bangladesh](StructureDefinition-bd-encounter.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-condition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 1 element

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Condition](http://hl7.org/fhir/R4/condition.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 1 element

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-condition.csv), [Excel](StructureDefinition-bd-condition.xlsx), [Schematron](StructureDefinition-bd-condition.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-patient.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-condition-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

