# Division - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Division**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-divisions-definitions.md) 
*  [Mappings](StructureDefinition-bd-divisions-mappings.md) 
*  [XML](StructureDefinition-bd-divisions.profile.xml.md) 
*  [JSON](StructureDefinition-bd-divisions.profile.json.md) 
*  [TTL](StructureDefinition-bd-divisions.profile.ttl.md) 

## Extension: Division 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-divisions | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Division |

BD Division

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Address for Bangladesh](StructureDefinition-bd-address.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-divisions)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type string: BD Division

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type string: BD Division

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-divisions.csv), [Excel](StructureDefinition-bd-divisions.xlsx), [Schematron](StructureDefinition-bd-divisions.sch) 

#### Terminology Bindings

#### Constraints

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-blood-group.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-divisions-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

