# Encounter Profile for Bangladesh - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Profile for Bangladesh**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-encounter-definitions.md) 
*  [Mappings](StructureDefinition-bd-encounter-mappings.md) 
*  [XML](StructureDefinition-bd-encounter.profile.xml.md) 
*  [JSON](StructureDefinition-bd-encounter.profile.json.md) 
*  [TTL](StructureDefinition-bd-encounter.profile.ttl.md) 

## Resource Profile: Encounter Profile for Bangladesh 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-encounter | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDEncounterProfile |

 
Profile of Encounter Bangladesh Standard 

**Usages:**

* Refer to this Profile: [Immunization Profile for Bangladesh](StructureDefinition-bd-immunization.md) and [Medication Request Profile for Bangladesh-V2](StructureDefinition-bd-medication-request.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

**Summary**

Mandatory: 5 elements
 Must-Support: 4 elements

**Structures**

This structure refers to these other structures:

* [ICD 11(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-condition)](StructureDefinition-bd-condition.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

**Summary**

Mandatory: 5 elements
 Must-Support: 4 elements

**Structures**

This structure refers to these other structures:

* [ICD 11(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-condition)](StructureDefinition-bd-condition.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-encounter.csv), [Excel](StructureDefinition-bd-encounter.xlsx), [Schematron](StructureDefinition-bd-encounter.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-condition.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-encounter-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

