# Immunization Profile for Bangladesh - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Profile for Bangladesh**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-immunization-definitions.md) 
*  [Mappings](StructureDefinition-bd-immunization-mappings.md) 
*  [XML](StructureDefinition-bd-immunization.profile.xml.md) 
*  [JSON](StructureDefinition-bd-immunization.profile.json.md) 
*  [TTL](StructureDefinition-bd-immunization.profile.ttl.md) 

## Resource Profile: Immunization Profile for Bangladesh 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-immunization | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDImmunizationProfile |

 
Bangladesh Immunization Profile 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-immunization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Patient Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-patient)](StructureDefinition-bd-patient.md)
* [Encounter Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-encounter)](StructureDefinition-bd-encounter.md)
* [Location of Immunization for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-location)](StructureDefinition-bd-location.md)
* [Organization for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-organization)](StructureDefinition-bd-organization.md)
* [Practitioner for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-practitioner)](StructureDefinition-bd-practitioner.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Immunization](http://hl7.org/fhir/R4/immunization.html) 

**Summary**

Mandatory: 2 elements

**Structures**

This structure refers to these other structures:

* [Patient Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-patient)](StructureDefinition-bd-patient.md)
* [Encounter Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-encounter)](StructureDefinition-bd-encounter.md)
* [Location of Immunization for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-location)](StructureDefinition-bd-location.md)
* [Organization for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-organization)](StructureDefinition-bd-organization.md)
* [Practitioner for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-practitioner)](StructureDefinition-bd-practitioner.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-immunization.csv), [Excel](StructureDefinition-bd-immunization.xlsx), [Schematron](StructureDefinition-bd-immunization.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-encounter.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-immunization-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

