# Bangladesh Observation Profile - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bangladesh Observation Profile**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-observation-definitions.md) 
*  [Mappings](StructureDefinition-bd-observation-mappings.md) 
*  [XML](StructureDefinition-bd-observation.profile.xml.md) 
*  [JSON](StructureDefinition-bd-observation.profile.json.md) 
*  [TTL](StructureDefinition-bd-observation.profile.ttl.md) 

## Resource Profile: Bangladesh Observation Profile 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-observation | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDObservationProfile |

 
Bangladesh Observation Profile 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 10 elements
 Must-Support: 8 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.value[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 10 elements
 Must-Support: 8 elements

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.value[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-observation.csv), [Excel](StructureDefinition-bd-observation.xlsx), [Schematron](StructureDefinition-bd-observation.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-medication.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-observation-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

