# Patient Profile for Bangladesh - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Profile for Bangladesh**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-patient-definitions.md) 
*  [Mappings](StructureDefinition-bd-patient-mappings.md) 
*  [XML](StructureDefinition-bd-patient.profile.xml.md) 
*  [JSON](StructureDefinition-bd-patient.profile.json.md) 
*  [TTL](StructureDefinition-bd-patient.profile.ttl.md) 

## Resource Profile: Patient Profile for Bangladesh 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-patient | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDPatientProfile |

 
Patient profile for Bangladesh. 
* Identifiers: NID, BRN, UHID
* Name must be provided in both Bangla and English.
* SHALL have at least one RelatedPerson with relationship = father or mother, and that RelatedPerson SHALL include both a name and an identifier.
 

**Usages:**

* Refer to this Profile: [Immunization Profile for Bangladesh](StructureDefinition-bd-immunization.md) and [Medication Request Profile for Bangladesh-V2](StructureDefinition-bd-medication-request.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Patient](http://hl7.org/fhir/R4/patient.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Patient](http://hl7.org/fhir/R4/patient.html) 

**Summary**

Mandatory: 8 elements(3 nested mandatory elements)
 Must-Support: 8 elements
 Fixed: 3 elements

**Structures**

This structure refers to these other structures:

* [Address for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-address)](StructureDefinition-bd-address.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/patient-religion](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-religion.html)
* [http://hl7.org/fhir/StructureDefinition/translation](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-translation.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Patient.identifier

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Patient](http://hl7.org/fhir/R4/patient.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Patient](http://hl7.org/fhir/R4/patient.html) 

**Summary**

Mandatory: 8 elements(3 nested mandatory elements)
 Must-Support: 8 elements
 Fixed: 3 elements

**Structures**

This structure refers to these other structures:

* [Address for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-address)](StructureDefinition-bd-address.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/StructureDefinition/patient-religion](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-religion.html)
* [http://hl7.org/fhir/StructureDefinition/translation](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-translation.html)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Patient.identifier

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-patient.csv), [Excel](StructureDefinition-bd-patient.xlsx), [Schematron](StructureDefinition-bd-patient.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](artifacts.md) | [top](#top) |  [next>](StructureDefinition-bd-patient-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

