# Practitioner for Bangladesh - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner for Bangladesh**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-practitioner-definitions.md) 
*  [Mappings](StructureDefinition-bd-practitioner-mappings.md) 
*  [XML](StructureDefinition-bd-practitioner.profile.xml.md) 
*  [JSON](StructureDefinition-bd-practitioner.profile.json.md) 
*  [TTL](StructureDefinition-bd-practitioner.profile.ttl.md) 

## Resource Profile: Practitioner for Bangladesh 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-practitioner | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDPractitioner |

 
Practitioner for Bangladesh Standard 

**Usages:**

* Refer to this Profile: [Immunization Profile for Bangladesh](StructureDefinition-bd-immunization.md) and [Medication Request Profile for Bangladesh-V2](StructureDefinition-bd-medication-request.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Constraints

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 1 element

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Constraints

 **Differential View** 

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Practitioner](http://hl7.org/fhir/R4/practitioner.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 1 element

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-practitioner.csv), [Excel](StructureDefinition-bd-practitioner.xlsx), [Schematron](StructureDefinition-bd-practitioner.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-organization.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-practitioner-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

