# Bangladesh Division ValueSet - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bangladesh Division ValueSet**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-bd-division-code-valueset.xml.md) 
*  [JSON](ValueSet-bd-division-code-valueset.json.md) 
*  [TTL](ValueSet-bd-division-code-valueset.ttl.md) 

## ValueSet: Bangladesh Division ValueSet 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/ValueSet/bd-division-code-valueset | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDDivisionsVS |

 
Bangladesh Division Codes (only two-digit codes) 

 **References** 

* [Division](StructureDefinition-bd-divisions.md)

### Logical Definition (CLD)

* Include codes from[`https://fhir.dghs.gov.bd/core/CodeSystem/bd-geocodes`](CodeSystem-bd-geocodes.md) version 📦0.2.0 where code matches (by regex) ^[0-9]{2}$

 

### Expansion

Expansion performed internally based on [codesystem Bangladesh GeoCodes CodeSystem v0.2.0 (CodeSystem)](CodeSystem-bd-geocodes.md)

This value set contains 8 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-bd-district-code-valueset.ttl.md) | [top](#top) |  [next>](ValueSet-bd-division-code-valueset-testing.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

