# BD Encounter Status Subset - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BD Encounter Status Subset**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-bd-encounter-status-subset.xml.md) 
*  [JSON](ValueSet-bd-encounter-status-subset.json.md) 
*  [TTL](ValueSet-bd-encounter-status-subset.ttl.md) 

## ValueSet: BD Encounter Status Subset 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/ValueSet/bd-encounter-status-subset | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDEncounterStatusSubsetVS |

 
Subset of EncounterStatus limited to planned, in-progress, finished, and cancelled. 

 **References** 

* [Encounter Profile for Bangladesh](StructureDefinition-bd-encounter.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://hl7.org/fhir/encounter-status`](http://hl7.org/fhir/R4/codesystem-encounter-status.html) version 📦4.0.1

 

### Expansion

Expansion performed internally based on [codesystem EncounterStatus v4.0.1 (CodeSystem)](http://hl7.org/fhir/R4/codesystem-encounter-status.html)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-bd-encounter-class-subset.ttl.md) | [top](#top) |  [next>](ValueSet-bd-encounter-status-subset-testing.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

