# Bangladesh Medication ValueSet - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bangladesh Medication ValueSet**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-bd-medication-valueset.xml.md) 
*  [JSON](ValueSet-bd-medication-valueset.json.md) 
*  [TTL](ValueSet-bd-medication-valueset.ttl.md) 

## ValueSet: Bangladesh Medication ValueSet 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/ValueSet/bd-medication-valueset | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDMedicationVS |

 
Bangladesh Medication ValueSet 

 **References** 

* [Medication Profile for Bangladesh-V2](StructureDefinition-bd-medication.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://fhir.dghs.gov.bd/core/CodeSystem/bd-medication-code`](CodeSystem-bd-medication-code.md) version 📦0.2.0

 

### Expansion

Expansion performed internally based on [codesystem Bangladesh Medication Codes v0.2.0 (CodeSystem)](CodeSystem-bd-medication-code.md)

This value set contains 6 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-bd-language-valueset.ttl.md) | [top](#top) |  [next>](ValueSet-bd-medication-valueset-testing.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

