# Table of Contents - Bangladesh Core FHIR Implementation Guide v0.2.0

* **Table of Contents**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

## Table of Contents

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

| |
| :--- |
| [0 Table of Contents](toc.md) |
| [1 BD-Core-FHIR-IG Home Page](index.md) |
| [2 Background and Context](background.md) |
| [3 Detailed BD-Core-FHIR Specification](spec.md) |
| [3.1 Fragments](fragments.md) |
| [3.2 Spec sub-page](spec2.md) |
| [4 Useful Downloads](downloads.md) |
| [5 IG Change History](changes.md) |
| [6 Artifacts Summary](artifacts.md) |
| [6.1 Patient Profile for Bangladesh](StructureDefinition-bd-patient.md) |
| [6.2 ICD 11](StructureDefinition-bd-condition.md) |
| [6.3 Encounter Profile for Bangladesh](StructureDefinition-bd-encounter.md) |
| [6.4 Immunization Profile for Bangladesh](StructureDefinition-bd-immunization.md) |
| [6.5 Location of Immunization for Bangladesh](StructureDefinition-bd-location.md) |
| [6.6 Medication Request Profile for Bangladesh-V2](StructureDefinition-bd-medication-request.md) |
| [6.7 Medication Profile for Bangladesh-V2](StructureDefinition-bd-medication.md) |
| [6.8 Bangladesh Observation Profile](StructureDefinition-bd-observation.md) |
| [6.9 Organization for Bangladesh](StructureDefinition-bd-organization.md) |
| [6.10 Practitioner for Bangladesh](StructureDefinition-bd-practitioner.md) |
| [6.11 Address for Bangladesh](StructureDefinition-bd-address.md) |
| [6.12 Patient Blood Group](StructureDefinition-bd-blood-group.md) |
| [6.13 Division](StructureDefinition-bd-divisions.md) |
| [6.14 Upazilla](StructureDefinition-bd-upazillas.md) |
| [6.15 Language Extension](StructureDefinition-language.md) |
| [6.16 Patient Nationality](StructureDefinition-nationality.md) |
| [6.17 Bangladesh Occupations](StructureDefinition-occupation-bd.md) |
| [6.18 Bangladesh Blood Group ValueSet](ValueSet-bd-blood-group-valueset.md) |
| [6.19 Bangladesh City Corperation ValueSet](ValueSet-bd-city-corporation-code-valueset.md) |
| [6.20 Bangladesh ICD-11 MMS ValueSet](ValueSet-bd-condition-icd11-valueset.md) |
| [6.21 Nationality ValueSet](ValueSet-bd-country-list-valueset.md) |
| [6.22 Bangladesh district ValueSet](ValueSet-bd-district-code-valueset.md) |
| [6.23 Bangladesh Division ValueSet](ValueSet-bd-division-code-valueset.md) |
| [6.24 Bangladesh Medication Dose Form ValueSet](ValueSet-bd-dose-form-valueset.md) |
| [6.25 BD Encounter Class Subset](ValueSet-bd-encounter-class-subset.md) |
| [6.26 BD Encounter Status Subset](ValueSet-bd-encounter-status-subset.md) |
| [6.27 Bangladesh Identifier Type](ValueSet-bd-identifier-type-valueset.md) |
| [6.28 Bangladesh Immunization Reaction Value Set](ValueSet-bd-immunization-reaction-valueset.md) |
| [6.29 Bangladesh Immunization Route Value Set](ValueSet-bd-immunization-route-valueset.md) |
| [6.30 Bangladesh Immunization Site Value Set](ValueSet-bd-immunization-site-valueset.md) |
| [6.31 Allowed Languages](ValueSet-bd-language-valueset.md) |
| [6.32 Bangladesh Medication ValueSet](ValueSet-bd-medication-valueset.md) |
| [6.33 Bangladesh Municipalities ValueSet](ValueSet-bd-municipalities-code-valueset.md) |
| [6.34 Bangladesh Occupations ValueSet](ValueSet-bd-occupations-valueset.md) |
| [6.35 Bangladesh Religions ValueSet](ValueSet-bd-religions-valueset.md) |
| [6.36 Bangladesh Upazila ValueSet](ValueSet-bd-upazilla-code-valueset.md) |
| [6.37 Bangladesh Vaccine Value Set](ValueSet-bd-vaccine-valueset.md) |
| [6.38 Bangladesh Blood Group CodeSystem](CodeSystem-bd-blood-groups.md) |
| [6.39 Nationality List](CodeSystem-bd-country-list.md) |
| [6.40 Bangladesh Medication Dose Form CodeSystem](CodeSystem-bd-dose-form.md) |
| [6.41 Bangladesh GeoCodes CodeSystem](CodeSystem-bd-geocodes.md) |
| [6.42 Bangladesh Identifier Types](CodeSystem-bd-identifier-type.md) |
| [6.43 Bangladesh Immunization Reaction Code System](CodeSystem-bd-immunization-reaction.md) |
| [6.44 Bangladesh Immunization Route Code System](CodeSystem-bd-immunization-route.md) |
| [6.45 Bangladesh Immunization Site Code System](CodeSystem-bd-immunization-site.md) |
| [6.46 Bangladesh Medication Codes](CodeSystem-bd-medication-code.md) |
| [6.47 Bangladesh Occupations](CodeSystem-bd-occupations.md) |
| [6.48 Bangladesh Religions](CodeSystem-bd-religions.md) |
| [6.49 Bangladesh Vaccine Code System](CodeSystem-bd-vaccine-code.md) |

| | | |
| :--- | :--- | :--- |
|  <prev | [top](#top) |  [next>](index.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

