# Patient Blood Group - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Blood Group**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-blood-group-definitions.md) 
*  [Mappings](StructureDefinition-bd-blood-group-mappings.md) 
*  [XML](StructureDefinition-bd-blood-group.profile.xml.md) 
*  [JSON](StructureDefinition-bd-blood-group.profile.json.md) 
*  [TTL](StructureDefinition-bd-blood-group.profile.ttl.md) 

## Extension: Patient Blood Group 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-blood-group | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDBloodGroup |

Blood group of the patient according to CCDS guideline

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-blood-group)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type CodeableConcept: Blood group of the patient according to CCDS guideline

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type CodeableConcept: Blood group of the patient according to CCDS guideline

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-blood-group.csv), [Excel](StructureDefinition-bd-blood-group.xlsx), [Schematron](StructureDefinition-bd-blood-group.sch) 

#### Terminology Bindings

#### Constraints

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-address.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-blood-group-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

