# Location of Immunization for Bangladesh - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Location of Immunization for Bangladesh**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-location-definitions.md) 
*  [Mappings](StructureDefinition-bd-location-mappings.md) 
*  [XML](StructureDefinition-bd-location.profile.xml.md) 
*  [JSON](StructureDefinition-bd-location.profile.json.md) 
*  [TTL](StructureDefinition-bd-location.profile.ttl.md) 

## Resource Profile: Location of Immunization for Bangladesh 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-location | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDLocation |

 
Address for Bangladesh Standard 

**Usages:**

* Refer to this Profile: [Immunization Profile for Bangladesh](StructureDefinition-bd-immunization.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

**Summary**

Mandatory: 1 element

**Structures**

This structure refers to these other structures:

* [Address for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-address)](StructureDefinition-bd-address.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Location](http://hl7.org/fhir/R4/location.html) 

**Summary**

Mandatory: 1 element

**Structures**

This structure refers to these other structures:

* [Address for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-address)](StructureDefinition-bd-address.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-location.csv), [Excel](StructureDefinition-bd-location.xlsx), [Schematron](StructureDefinition-bd-location.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-immunization.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-location-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

