# Artifacts Summary - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

## Artifacts Summary

Contents:

*  [Structures: Resource Profiles](#1) 
*  [Structures: Data Type Profiles](#2) 
*  [Structures: Extension Definitions](#3) 
*  [Terminology: Value Sets](#4) 
*  [Terminology: Code Systems](#5) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Bangladesh Observation Profile](StructureDefinition-bd-observation.md) | Bangladesh Observation Profile |
| [Encounter Profile for Bangladesh](StructureDefinition-bd-encounter.md) | Profile of Encounter Bangladesh Standard |
| [ICD 11](StructureDefinition-bd-condition.md) | Condition coded with ICD-11 |
| [Immunization Profile for Bangladesh](StructureDefinition-bd-immunization.md) | Bangladesh Immunization Profile |
| [Location of Immunization for Bangladesh](StructureDefinition-bd-location.md) | Address for Bangladesh Standard |
| [Medication Profile for Bangladesh-V2](StructureDefinition-bd-medication.md) | Profile of Medication Bangladesh Standard V2 |
| [Medication Request Profile for Bangladesh-V2](StructureDefinition-bd-medication-request.md) | Profile of MedicationRequest Bangladesh Standard V2 |
| [Organization for Bangladesh](StructureDefinition-bd-organization.md) | Organization for Bangladesh Standard |
| [Patient Profile for Bangladesh](StructureDefinition-bd-patient.md) | Banlgladesh Patient Profile |
| [Practitioner for Bangladesh](StructureDefinition-bd-practitioner.md) | Practitioner for Bangladesh Standard |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address for Bangladesh](StructureDefinition-bd-address.md) | Address for Bangladesh Standard |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Bangladesh Occupations](StructureDefinition-occupation-bd.md) | Occupation |
| [Division](StructureDefinition-bd-divisions.md) | BD Division |
| [Language Extension](StructureDefinition-language.md) | Language |
| [Patient Blood Group](StructureDefinition-bd-blood-group.md) | Blood group of the patient according to CCDS guideline |
| [Patient Nationality](StructureDefinition-nationality.md) | Nationality of the patient based on Bangladesh country list. |
| [Upazilla](StructureDefinition-bd-upazillas.md) | BD Upazilla |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Allowed Languages](ValueSet-bd-language-valueset.md) | Only English and Bengali are allowed |
| [BD Encounter Class Subset](ValueSet-bd-encounter-class-subset.md) | Subset of EncounterClass limited to inpatient, ambulatory, and emergency. |
| [BD Encounter Status Subset](ValueSet-bd-encounter-status-subset.md) | Subset of EncounterStatus limited to planned, in-progress, finished, and cancelled. |
| [Bangladesh Blood Group ValueSet](ValueSet-bd-blood-group-valueset.md) | Blood group value set according to CCDS guideline |
| [Bangladesh City Corperation ValueSet](ValueSet-bd-city-corporation-code-valueset.md) | Bangladesh City Corperation Codes (only two-digit codes) |
| [Bangladesh Division ValueSet](ValueSet-bd-division-code-valueset.md) | Bangladesh Division Codes (only two-digit codes) |
| [Bangladesh ICD-11 MMS ValueSet](ValueSet-bd-condition-icd11-valueset.md) | ValueSet that includes the ICD-11 MMS CodeSystem for Condition.code |
| [Bangladesh Identifier Type](ValueSet-bd-identifier-type-valueset.md) | Bangladesh Standard Identifier type |
| [Bangladesh Immunization Reaction Value Set](ValueSet-bd-immunization-reaction-valueset.md) | Allowed vaccine reactions for immunization in Bangladesh. |
| [Bangladesh Immunization Route Value Set](ValueSet-bd-immunization-route-valueset.md) | Allowed administration routes for vaccines in Bangladesh. |
| [Bangladesh Immunization Site Value Set](ValueSet-bd-immunization-site-valueset.md) | Allowed administration sites for vaccines in Bangladesh. |
| [Bangladesh Medication Dose Form ValueSet](ValueSet-bd-dose-form-valueset.md) | Medication dose form value set according to CCDS guideline |
| [Bangladesh Medication ValueSet](ValueSet-bd-medication-valueset.md) | Bangladesh Medication ValueSet |
| [Bangladesh Municipalities ValueSet](ValueSet-bd-municipalities-code-valueset.md) | Bangladesh Municipalities Codes (only two-digit codes) |
| [Bangladesh Occupations ValueSet](ValueSet-bd-occupations-valueset.md) | Occupations value set according to CCDS guideline |
| [Bangladesh Religions ValueSet](ValueSet-bd-religions-valueset.md) | Religions value set according to CCDS guideline |
| [Bangladesh Upazila ValueSet](ValueSet-bd-upazilla-code-valueset.md) | Bangladesh Upazila Codes (only two-digit codes) |
| [Bangladesh Vaccine Value Set](ValueSet-bd-vaccine-valueset.md) | Allowed vaccines for immunization in Bangladesh. |
| [Bangladesh district ValueSet](ValueSet-bd-district-code-valueset.md) | Bangladesh district Codes (only two-digit codes) |
| [Nationality ValueSet](ValueSet-bd-country-list-valueset.md) | Nationality value set |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Bangladesh Blood Group CodeSystem](CodeSystem-bd-blood-groups.md) | Blood group codes according to CCDS guideline |
| [Bangladesh GeoCodes CodeSystem](CodeSystem-bd-geocodes.md) | Bangladesh GeoCodes |
| [Bangladesh Identifier Types](CodeSystem-bd-identifier-type.md) | Codes identifying the type of identifiers used in Bangladesh. |
| [Bangladesh Immunization Reaction Code System](CodeSystem-bd-immunization-reaction.md) | Codes for adverse reactions after vaccination in Bangladesh. |
| [Bangladesh Immunization Route Code System](CodeSystem-bd-immunization-route.md) | Codes for routes of vaccine administration in Bangladesh. |
| [Bangladesh Immunization Site Code System](CodeSystem-bd-immunization-site.md) | Codes for anatomical site of vaccine administration in Bangladesh. |
| [Bangladesh Medication Codes](CodeSystem-bd-medication-code.md) | Bangladesh Medication Codes |
| [Bangladesh Medication Dose Form CodeSystem](CodeSystem-bd-dose-form.md) | Medication dose form codes according to CCDS guideline |
| [Bangladesh Occupations](CodeSystem-bd-occupations.md) | Occupations code system according to CCDS guideline |
| [Bangladesh Religions](CodeSystem-bd-religions.md) |  |
| [Bangladesh Vaccine Code System](CodeSystem-bd-vaccine-code.md) | Vaccine codes used in Bangladesh EPI and immunization program. |
| [Nationality List](CodeSystem-bd-country-list.md) |  |

| | | |
| :--- | :--- | :--- |
|  [<prev](changes.md) | [top](#top) |  [next>](StructureDefinition-bd-patient.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

