# Background and Context - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* **Background and Context**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

## Background and Context

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Contents:

* [Motivation](#1)
* [Scope](#2)
* [National Digital Health Architecture](#3)

 The Bangladesh Core FHIR Implementation Guide defines national base profiles, code systems, and value sets to ensure interoperability across digital health systems under DGHS and MoHFW. 

### Motivation

 Bangladesh has multiple health information systems developed over the years, including DHIS2, multiple hospital automation systems, field automation systems, and HRIS. These systems use different data standards, which makes interoperability difficult. This guide aligns national systems with HL7® FHIR® R4 to ensure semantic consistency and facilitate integration with global initiatives. 

### Scope

* Patient identity management (UHID, NID, BRN)
* Health facility and organization registry
* Immunization, laboratory, and condition profiles
* Terminology services (ICD-11, SNOMED subsets, local CodeSystems)

### National Digital Health Architecture

 The following diagram shows how FHIR-based services are integrated into Bangladesh's national digital health architecture: 

 ![](bd-core-architecture.png) 

| | | |
| :--- | :--- | :--- |
|  [<prev](index.md) | [top](#top) |  [next>](spec.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

