# Medication Request Profile for Bangladesh-V2 - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Request Profile for Bangladesh-V2**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-bd-medication-request-definitions.md) 
*  [Mappings](StructureDefinition-bd-medication-request-mappings.md) 
*  [XML](StructureDefinition-bd-medication-request.profile.xml.md) 
*  [JSON](StructureDefinition-bd-medication-request.profile.json.md) 
*  [TTL](StructureDefinition-bd-medication-request.profile.ttl.md) 

## Resource Profile: Medication Request Profile for Bangladesh-V2 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/StructureDefinition/bd-medication-request | *Version*:0.2.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BDMedicationRequest |

 
Profile of MedicationRequest Bangladesh Standard V2 

**Usages:**

* Refer to this Profile: [Medication Request Profile for Bangladesh-V2](StructureDefinition-bd-medication-request.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/bd.fhir.core|current/StructureDefinition/bd-medication-request)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

**Summary**

Mandatory: 3 elements
 Must-Support: 2 elements

**Structures**

This structure refers to these other structures:

* [Practitioner for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-practitioner)](StructureDefinition-bd-practitioner.md)
* [Organization for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-organization)](StructureDefinition-bd-organization.md)
* [Patient Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-patient)](StructureDefinition-bd-patient.md)
* [Medication Profile for Bangladesh-V2(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-medication)](StructureDefinition-bd-medication.md)
* [Encounter Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-encounter)](StructureDefinition-bd-encounter.md)
* [Medication Request Profile for Bangladesh-V2(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-medication-request)](StructureDefinition-bd-medication-request.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of MedicationRequest.reported[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) 

**Summary**

Mandatory: 3 elements
 Must-Support: 2 elements

**Structures**

This structure refers to these other structures:

* [Practitioner for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-practitioner)](StructureDefinition-bd-practitioner.md)
* [Organization for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-organization)](StructureDefinition-bd-organization.md)
* [Patient Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-patient)](StructureDefinition-bd-patient.md)
* [Medication Profile for Bangladesh-V2(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-medication)](StructureDefinition-bd-medication.md)
* [Encounter Profile for Bangladesh(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-encounter)](StructureDefinition-bd-encounter.md)
* [Medication Request Profile for Bangladesh-V2(https://fhir.dghs.gov.bd/core/StructureDefinition/bd-medication-request)](StructureDefinition-bd-medication-request.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of MedicationRequest.reported[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 1

 

Other representations of profile: [CSV](StructureDefinition-bd-medication-request.csv), [Excel](StructureDefinition-bd-medication-request.xlsx), [Schematron](StructureDefinition-bd-medication-request.sch) 

| | | |
| :--- | :--- | :--- |
|  [<prev](StructureDefinition-bd-location.profile.ttl.md) | [top](#top) |  [next>](StructureDefinition-bd-medication-request-definitions.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

