# BD-Core-FHIR-IG Home Page - Bangladesh Core FHIR Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* **BD-Core-FHIR-IG Home Page**

Bangladesh Core FHIR Implementation Guide - Published by Ministry of Health and Family Welfare. See the [Directory of published versions](https://fhir.dghs.gov.bd/core/history.html)

## BD-Core-FHIR-IG Home Page

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.dghs.gov.bd/core/ImplementationGuide/bd.fhir.core | *Version*:0.2.0 | |
| *IG Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BangladeshCoreFHIRIG |

Contents:

* [Introduction](#intro)
* [Technical Overview](#technical)

### Introduction

 The Bangladesh Core FHIR Implementation Guide (BD-Core-FHIR-IG) is part of the Bangladesh Digital Health Blueprint. It defines how health information should be exchanged across systems in Bangladesh in a safe, standardized, and interoperable way. 

 By adopting international FHIR standards, this guide helps ensure that patient data can flow smoothly between hospitals, clinics, and national programs, while also enabling future cross-border health information exchange. 

### Technical Overview

 This guide provides national FHIR profiles, value sets, and terminology bindings that software developers and system implementers must use when designing digital health applications for Bangladesh. Using these standards ensures consistency, reduces duplication, and supports patient-centered care. 

 The main sections of this IG are: 

* [Background](background.md) - Context and rationale for the IG
* [Detailed Specification](spec.md) - Profiles, value sets, and conformance requirements
* [Fragments](fragments.md) - Guidance about how to embed fragments in an IG
* [Downloads](downloads.md) - Allows downloading a copy of this implementation guide and other useful information

| | | |
| :--- | :--- | :--- |
|  [<prev](toc.md) | [top](#top) |  [next>](background.md) |

 IG © 2025+ [Directorate General of Health Services (DGHS), Bangladesh](http://dghs.gov.bd). Package bd.fhir.core#0.2.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

